<?php
   session_start();

   $jsonFile = __DIR__ . "/../data.json";

   // Load database JSON
   if (!file_exists($jsonFile)) {
       http_response_code(404);
       echo "Database tidak ditemukan.";
       exit;
   }

   $data = json_decode(file_get_contents($jsonFile), true);
   if ($data === null) {
       http_response_code(500);
       echo "Gagal membaca database.";
       exit;
   }

   // Ambil slug dari URL
   $requestUri = trim($_SERVER['REQUEST_URI'] ?? '', '/');
   $slug = preg_replace('#^e/#', '', $requestUri);

   // Debug: Log slug yang diterima
   error_log("Slug yang diterima: " . $slug);

   if ($slug === '' || !isset($data[$slug])) {
       error_log("Slug tidak ditemukan di data.json: " . $slug);
       http_response_code(404);
       echo "Shortlink tidak ditemukan.";
       exit;
   }

   // Ambil URL asli dari data
   $originalUrl = $data[$slug]['original'];

   // Nonaktifkan cache
   header("Cache-Control: no-cache, must-revalidate");
   header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");

   // Redirect ke URL asli
   header("Location: $originalUrl", true, 301);
   exit;
   ?>